import sys
sys.path = ['C:/Users/contestant/OSEHRA/Dashboards/OSEHRA-Automated-Testing/Python'] + sys.path

from OSEHRAHelper import PROMPT
from ConnectToVista import ConnectToVista
from AddOneInstitution import AddOneInstitution
from AddHCSDivision import AddHCSDivision
from AddOneDivision import AddOneDivision, AddOneDivisionP
from AddOneServiceSection import AddOneServiceSection
from AddOneAppointmentType import AddOneAppointmentType
from AddOneHoliday import AddOneHoliday
from AddOneDoctor import AddOneDoctor
from AddDoctors import GoToUserManagementMenu, GoToPrompt
import copy
from suds.client import Client
from ReplaceDatabase import ReplaceDatabase
from time import sleep

if len(sys.argv) > 1:
	if sys.argv[1] == '-verbose':
		logdetail = 1
	else:
		logdetail = 0
else:
	logdetail = 0

url = 'http://127.0.0.1/WCFService/Service1.svc?wsdl'
client = Client(url, timeout=18000)

state = 'CALIFORNIA'
state_short = 'CA'
domain = 'CA.VA.GOV'
facility1_site_id = '555'
facility2_abbr = 'CVARMC'
facility3_abbr = 'CVAOPC'

facility1 = state_short + ' VA HEALTH CARE SYSTEM'
facility2 = state_short + ' VA REGIONAL MEDICAL CENTER'
facility2_site_id = facility1_site_id + 'MC'
facility3 = state_short + ' VA OUTPATIENT CLINIC'
facility3_site_id = facility1_site_id + 'OC'

print 'initializing vista and sql db...'
print 'plesae wait...'
client.service.RestoreDBToSnapShot("SchedulingUseCase1Baseline")
ReplaceDatabase("C:/DBBackups/vista/usecase1/cache.dat")
sleep(60)
#print 'done!!!'

VistA=ConnectToVista('ca_use_case_1.log')

print 'setp 1'
AddOneInstitution(VistA,facility1,'',facility1_site_id,'MC','4529860114','Y','VAMC','HEADQUARTERS ' + state_short + ' HEALTH CARE SYSTEM','','SACRAMENTO',state,'94203','(916)555-1212','')
AddHCSDivision(VistA,facility1,facility1_site_id,'1')
AddOneDivisionP(VistA, facility1,'1',facility1_site_id)
print '\tstep 1 - facility 1 is added:  '  + facility1

print 'step 2'
AddOneInstitution(VistA,facility2,facility2_abbr,facility2_site_id,'MC','8890253874','N','VAMC',state_short + ' VA REGIONAL MEDICAL CENTER','23 BRADFORD AVENUE','SACRAMENTO',state,'94203','(916)555-XXXX','')
AddOneDivision(VistA, facility2,'1',facility2_site_id)

AddOneInstitution(VistA,facility3,facility3_abbr,facility3_site_id,'','7764091279','N','CBOC',state_short + ' VA OUTPATIENT CLINIC','23 ECKERD AVENUE','SACRAMENTO',state,'94203','(916)555-XXXX','')
AddOneDivision(VistA, facility3,'1',facility3_site_id)
print '\tstep 2 - facility 2 is added:  '  + facility2
print '\tstep 2 - facility 3 is added:  '  + facility3

print 'step3'
#AddOneServiceSection(VistA, "MEDICINE", "C")
print '\tstep 3 - MEDICINE service is added'
#AddOneServiceSection(VistA, "SURGICAL", "C")
print '\tstep 3 - SURGICAL service is added'
#AddOneServiceSection(VistA, "PSYCHIATRIC", "C")
print '\tstep 3 - PSYCHIATRIC service is added'
#AddOneServiceSection(VistA, "ANCILLARY", "")
print '\tstep 3 - ANCILLARY service is added'

print 'step4'
#AddOneAppointmentType(VistA, "REGULAR")
print '\tstep 4 - REGULAR appointment type is added'
#AddOneAppointmentType(VistA, "COMPENSATION & PENSION")
print '\tstep 4 - COMPENSATION appointment type is added'
#AddOneAppointmentType(VistA, "EMPLOYEE")
print '\tstep 4 - EMPLOYEE appointment type is added'

print 'step5'
AddOneHoliday(VistA,'National VA Organization Day','JUL 20, 2012')
AddOneHoliday(VistA,'National VA Organization Day','JUL 22, 2013')
AddOneHoliday(VistA,'National VA Organization Day','JUL 21, 2014')
'\tstep 5 - National VA Organization Day holidays are added'
AddOneHoliday(VistA,'Valentines\' Day','FEB 13, 2012')
AddOneHoliday(VistA,'Valentines\' Day','FEB 14, 2013')
AddOneHoliday(VistA,'Valentines\' Day','FEB 14, 2014')
'\tstep 5 - Valentines\' Day holidays are added'

#import devisions/facilities, service/section, appointment type and holidays
result = client.service.ImportSite(facility1_site_id)
result = client.service.ImportSite(facility1_site_id)
result = client.service.ImportSite(facility1_site_id)
#print result
print 'imported devisions/facilities, service/section, appointment type and holidays from VistA'

print 'step 6'
services = client.service.GetServices()
for p in services.Service:
	if p.Name == 'MEDICINE':
		service_id = p.Id
		break;

facilities = client.service.GetFacilities(client.service.GetFromVistaSiteId(facility1_site_id).Id)
for p in facilities.Facility:
	if p.Name == facility2:
		facility_id = p.Id
		break;

section = client.factory.create('ns0:Section')
section.Abbreviation = 'PC'
section.Active = 1
section.DSSPrimaryStopCode = '323 MEDICAL PROCEDURE UNIT'
section.Hours = '0800-1600'
section.Location = 'WEST WING ROOM 1'
section.Name = 'PRIMARY CARE'
facility = client.factory.create('ns0:Facility')
facility.Id = facility_id
section.Facility = facility
service = client.factory.create('ns0:Service')
service.Id = service_id
section.Service = service
result = client.service.AddSection(section);
section1_result = copy.deepcopy(result)

if logdetail == 1:
	print section1_result

	for p in facilities.Facility:
		if p.Name == facility3:
			facility_id = p.Id
			break;
section2 = client.factory.create('ns0:Section')
section2.Abbreviation = 'PC'
section2.Active = 1
section2.DSSPrimaryStopCode = '323 MEDICAL PROCEDURE UNIT'
section2.Hours = '0800-1500'
section2.Location = 'EAST WING ROOMS 10 AND 11'
section2.Name = 'PRIMARY CARE'
facility = client.factory.create('ns0:Facility')
facility.Id = facility_id
section2.Facility = facility
service = client.factory.create('ns0:Service')
service.Id = service_id
section2.Service = service
result = client.service.AddSection(section2)
section2_result = copy.deepcopy(result)

if logdetail == 1:
	print section2_result
print '\tstep 6 - primary care clinic is added to ' + facility2 + '.'
print '\tstep 6 - primary care clinic is added to ' + facility3 + '.'

print 'step 7'
facilities = client.service.GetFacilities(client.service.GetFromVistaSiteId(facility1_site_id).Id)
for p in facilities.Facility:
	if p.Name == facility2:
		comtemp = client.factory.create('ns0:CommunicationTemplate')
		comtemp.Name = 'CASE1 STEP 7 TEST'
		comtemp.Type = 'PreAppointment'
		comtemp.Message = "SAMPLE PRE-APPOINTMENT LETTER SINCERELY"
		comtemp.Medium = "Email"
		comtemp.Recipient = "Patient"
		comtemp.Subject = "Pre appointment notice"
		result = client.service.AddUpdateFacilityCommunicationTemplate(p.Id, comtemp);
		comptemp_result = copy.deepcopy(result)
				
		if logdetail == 1:
			print comptemp_result
		break;
print '\tstep 7 - pre-appointment communication template is created'

print 'step 8'
comtemp = client.factory.create('ns0:CommunicationTemplate')
comtemp.Name = 'CASE1 STEP 8 TEST'
comtemp.Type = 'PreAppointment'
comtemp.Message = "SAMPLE PRE-APPOINTMENT LETTER SINCERELY"
comtemp.Medium = "Email"
comtemp.Recipient = "Patient"
comtemp.Subject = "Pre appointment notice"
result = client.service.AddUpdateSectionCommunicationTemplate(section1_result.Id, comtemp);
comptemp2_result = copy.deepcopy(result)
if logdetail == 1:
	print comptemp2_result
print '\tstep 8 - pre-appointment communication template is assigned to primary care section in ' + facility2

sleep(5)
print 'step 9'
GoToUserManagementMenu(VistA)
AddOneDoctor(VistA,'ONE,PROVIDER','OP','872983756','','M','PROONE1','password','PROONE1','769',facility2)
AddOneDoctor(VistA,'TWO,PROVIDER','TP','872983757','','F','PROTWO2','password','PROTWO2','769',facility3)
GoToPrompt(VistA)

sleep(5)
result = client.service.ImportProviders(facility1_site_id)
providers = client.service.GetAllProviders()
for p in providers.Provider:
	if p.Person.FirstName == 'PROVIDER' and p.Person.LastName == 'ONE':
		provider_id = p.Id
		break;
resource = client.factory.create('ns0:Resource')
holds = client.factory.create('ns0:ArrayOfHold')
blocks = client.factory.create('ns0:ArrayOfBlock')
schdPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
a = []
blocks.Block = a
resource.Blocks = blocks
holds.Hold = a
resource.Holds = holds
schdPolicies.SchedulingPolicy = a
resource.Name = 'case1 step 9 test'
resource.Section = client.service.GetSection(section2_result.Id)
resource.Type = 'Provider'
resource.FullfillingResourceId = provider_id
result = client.service.AddResource(resource)
resource_result = copy.deepcopy(result)
print '\tstep 9 - a resource is added to ' + facility3 + ' and schedule is added for one,provider'

print 'checkpoint 1 & 2'
print 'step 1 - check facility 1'
results = client.service.VistaQuery(facility1_site_id, "4", "@;.01;1.01;1.02;1.03;1.04;99")
for p in results.string:
	result = p.split('^')
	if result[6] == facility1_site_id:
		print '\tmatching site id'
		phone_results = client.service.VistaQuery_WithIEN(facility1_site_id, "4.03", ","+result[0]+",", ".03")
		phone = phone_results.string[0].split('^')
		if result[1] == facility1:
			print '\tmatching facility name'
		if result[2] == 'HEADQUARTERS ' + state_short + ' HEALTH CARE SYSTEM':
			print '\tmatching street address 1'
		if logdetail == 1:
			print result
		break;	

print 'step 1 - check division 1'
results = client.service.VistaQuery(facility1_site_id, "40.8", "@;.01;1")
for p in results.string:
	result = p.split('^')
	if result[2] == facility1_site_id:
		print '\tmatching site id'
		if result[1] == facility1:
			print '\tmatching division name'
		if logdetail == 1:
			print result

print 'step 2 - check facility 2'
results = client.service.VistaQuery(facility1_site_id, "4", "@;.01;1.01;1.02;1.03;1.04;99")
for p in results.string:
	result = p.split('^')
	if result[6] == facility2_site_id:
		print '\tmatching site id'
		phone_results = client.service.VistaQuery_WithIEN(facility1_site_id, "4.03", ","+result[0]+",", ".03")
		phone = phone_results.string[0].split('^')
		if result[1] == facility2:
			print '\tmatching facility name'
		if result[2] == state_short + ' VA REGIONAL MEDICAL CENTER':
			print '\tmatching street address 1'
		if logdetail == 1:
			print result
		break;	

facilities = client.service.GetFacilities(client.service.GetFromVistaSiteId(facility1_site_id).Id)
for p in facilities.Facility:
	if p.Name == facility2:
		print '\tmatching sql data'
		if logdetail == 1:
			print p
		break;
		
print 'step 2 - check division 2'
results = client.service.VistaQuery(facility1_site_id, "40.8", "@;.01;1")
for p in results.string:
	result = p.split('^')
	if result[2] == facility2_site_id:
		print '\tmatching site id'
		if result[1] == facility2:
			print '\tmatching division name'
		if logdetail == 1:
			print result

print 'step 2 - check facility 3'
results = client.service.VistaQuery(facility1_site_id, "4", "@;.01;1.01;1.02;1.03;1.04;99")
for p in results.string:
	result = p.split('^')
	if result[6] == facility3_site_id:
		print '\tmatching site id'
		phone_results = client.service.VistaQuery_WithIEN(facility1_site_id, "4.03", ","+result[0]+",", ".03")
		phone = phone_results.string[0].split('^')
		if result[1] == facility3:
			print '\tmatching facility name'
		if result[2] == state_short + ' VA OUTPATIENT CLINIC':
			print '\tmatching street address 1'
		if logdetail == 1:
			print result
		break;	
		
facilities = client.service.GetFacilities(client.service.GetFromVistaSiteId(facility1_site_id).Id)
for p in facilities.Facility:
	if p.Name == facility3:
		print '\tmatching sql data'
		if logdetail == 1:
			print p
		break;

print 'step 2 - check division 3'
results = client.service.VistaQuery(facility1_site_id, "40.8", "@;.01;1")
for p in results.string:
	result = p.split('^')
	if result[2] == facility3_site_id:
		print '\tmatching site id'
		if result[1] == facility3:
			print '\tmatching division name'
		if logdetail == 1:
			print result

print 'step 3 - check service/section'
results = client.service.VistaQuery(facility1_site_id, "49", "@;.01")
results1 = client.service.GetServices()

for p in results.string:
	result = p.split('^')
	if result[1] == 'MEDICINE':
		for p1 in results1.Service:
			if p1.Name == 'MEDICINE':
				print '\tfound SERVICE/SECTION: MEDICINE'
		if logdetail == 1:
			print result
		break;
for p in results.string:
	result = p.split('^')
	if result[1] == 'SURGICAL':
		for p1 in results1.Service:
			if p1.Name == 'SURGICAL':
				print '\tfound SERVICE/SECTION: SURGICAL'
		if logdetail == 1:
			print result
		break;
for p in results.string:
	result = p.split('^')
	if result[1] == 'PSYCHIATRIC':
		for p1 in results1.Service:
			if p1.Name == 'PSYCHIATRIC':
				print '\tfound SERVICE/SECTION: PSYCHIATRIC'
		if logdetail == 1:
			print result				
		break;
for p in results.string:
	result = p.split('^')
	if result[1] == 'ANCILLARY':
		for p1 in results1.Service:
			if p1.Name == 'ANCILLARY':
				print '\tfound SERVICE/SECTION: ANCILLARY'
		if logdetail == 1:
			print result
			break;

print 'step 4 - check appointment type'
results = client.service.VistaQuery(facility1_site_id, "409.1", "@;.01")
if logdetail == 1:
	print results
results1 = client.service.GetAppointmentTypeCategories(facility1_site_id)
if logdetail == 1:
	print results1

for p in results.string:
	result = p.split('^')
	if result[1] == 'REGULAR':
		for p1 in results1.AppointmentTypeCategory:
			if p1.Name == 'REGULAR':
				print '\tfound Appointment Type: REGULAR'
		if logdetail == 1:
			print result
		break;
for p in results.string:
	result = p.split('^')
	if result[1] == 'COMPENSATION & PENSION':
		for p1 in results1.AppointmentTypeCategory:
			if p1.Name == 'COMPENSATION & PENSION':
				print '\tfound Appointment Type: COMPENSATION & PENSION'
		if logdetail == 1:
			print result
		break;
for p in results.string:
	result = p.split('^')
	if result[1] == 'EMPLOYEE':
		for p1 in results1.AppointmentTypeCategory:
			if p1.Name == 'EMPLOYEE':
				print '\tfound Appointment Type: EMPLOYEE'
		if logdetail == 1:
			print result
		break;

print 'step 5 - check holidays'
results = client.service.VistaQuery(facility1_site_id, "40.5", "@;.01;2")
results1 = client.service.GetHolidays()
for p in results.string:
	result = p.split('^')
	if result[1] == 'JUL 20, 2012' and result[2] == 'National VA Organization Day':
		for p1 in results1.Holiday:
			if p1.Name == 'National VA Organization Day' and str(p1.Date) == '2012-07-20 00:00:00':
				print '\tfound holiday:  National VA Organization Day - 20 JULY 2012'
		if logdetail == 1:
			print result
		break;
for p in results.string:
	result = p.split('^')
	if result[1] == 'JUL 22, 2013' and result[2] == 'National VA Organization Day':
		for p1 in results1.Holiday:
			if p1.Name == 'National VA Organization Day' and str(p1.Date) == '2013-07-22 00:00:00':
				print '\tfound holiday:  National VA Organization Day - 22 JULY 2013'
		if logdetail == 1:
			print result
		break;
for p in results.string:
	result = p.split('^')
	if result[1] == 'JUL 21, 2014' and result[2] == 'National VA Organization Day':
		for p1 in results1.Holiday:
			if p1.Name == 'National VA Organization Day' and str(p1.Date) == '2014-07-21 00:00:00':
				print '\tfound holiday:  National VA Organization Day - 21 JULY 2014'
		if logdetail == 1:
			print result
		break;
for p in results.string:
	result = p.split('^')
	if result[1] == 'FEB 13, 2012' and result[2] == 'Valentines\' Day':
		for p1 in results1.Holiday:
			if p1.Name == 'Valentines\' Day' and str(p1.Date) == '2012-02-13 00:00:00':
				print '\tfound holiday:  Valentines\' Day - 13 FEB 2012'
		if logdetail == 1:
			print result
		break;
for p in results.string:
	result = p.split('^')
	if result[1] == 'FEB 14, 2013' and result[2] == 'Valentines\' Day':
		for p1 in results1.Holiday:
			if p1.Name == 'Valentines\' Day' and str(p1.Date) == '2013-02-14 00:00:00':
				print '\tfound holiday:  Valentines\' Day - 14 FEB 2013'
		if logdetail == 1:
			print result
		break;
for p in results.string:
	result = p.split('^')
	if result[1] == 'FEB 14, 2014' and result[2] == 'Valentines\' Day':
		for p1 in results1.Holiday:
			if p1.Name == 'Valentines\' Day' and str(p1.Date) == '2014-02-14 00:00:00':
				print '\tfound holiday:  Valentines\' Day - 14 FEB 2014'
		if logdetail == 1:
			print result
		break;

print 'step 6 - check section'
if logdetail == 1:
	print section1_result
print '\tprimary care section is created on ' + facility2
if logdetail == 1:
	print section2_result
print '\tprimary care section is created on ' + facility3

print 'step 7 - check pre-appointment communication template'
if logdetail == 1:
	print comptemp_result
print '\tpre-appointment communication template was created'

print 'step 8 - check pre-appointment communication letter for a section'
if logdetail == 1:
	print section1_result
print '\tpre-appointment communication template is assigned to primary care section in ' + facility2

print 'step 9 - check pre-appointment communication letter for a section'
if logdetail == 1:
	print section2_result
print 'a resource was added to ' + facility3 + 'schedule is added for one,provider'

print 'step 11'
section = client.service.GetSection(section2_result.Id)
section.Active = '0'
result = client.service.UpdateSection(section)
section2_result = copy.deepcopy(result)
print '\tstep 11 - deactivated a section'

print 'checkpoint 3'
if logdetail == 1:
	print section2_result
print '\tsection got deactivated'


print 'step 12'
section = client.service.GetSection(section2_result.Id)
section.Active = '1'
result = client.service.UpdateSection(section)
section2_result = copy.deepcopy(result)
print '\tstep 12 - reactivated a section'

print 'checkpoint 4'
if logdetail == 1:
	print section2_result
print '\tsection got reactivated'
